/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.ai.goals.ApproachTargetGoal;
import com.alexander.mutantmore.ai.goals.LookAtTargetGoal;
import com.alexander.mutantmore.config.MutantMoreGroupedOptionsCommonConfig;
import com.alexander.mutantmore.config.RodlingCommonConfig;
import com.alexander.mutantmore.entities.RodlingFireball;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.particles.EntityTrackingParticleOption;
import com.alexander.mutantmore.util.GuiUtils;
import com.alexander.mutantmore.util.MiscUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Rodling
extends TamableAnimal
implements IAnimatable,
IAnimationTickable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Boolean> WANTS_TO_SIT = SynchedEntityData.m_135353_(Rodling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(Rodling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ARMOURED = SynchedEntityData.m_135353_(Rodling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_SHIELDS = SynchedEntityData.m_135353_(Rodling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BURNS_BLOCKS = SynchedEntityData.m_135353_(Rodling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALWAYS_SHOWS_NAME = SynchedEntityData.m_135353_(Rodling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SOUL = SynchedEntityData.m_135353_(Rodling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHIELDS = SynchedEntityData.m_135353_(Rodling.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int regenerateShieldTick;
    public int regenerateShieldTime = 150;
    public int shootAnimationTick;
    public int shootAnimationLength = 22;
    public int shootAnimationActionPoint = 7;
    public int noveltyAnimationTick;
    public int noveltyAnimationLength = 30;

    public Rodling(EntityType<? extends Rodling> p_i50189_1_, Level p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.m_7105_(false);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        if (!this.m_21824_()) {
            this.f_21364_ = (Integer)RodlingCommonConfig.hostile_exp_reward.get();
            this.regenerateShieldTime = (Integer)RodlingCommonConfig.hostile_shield_regenerate_speed.get();
        } else {
            this.regenerateShieldTime = (Integer)RodlingCommonConfig.tamed_shield_regenerate_speed.get();
        }
    }

    public void m_7105_(boolean p_21836_) {
        super.m_7105_(p_21836_);
        this.updateConfigurableAttributeValues(false);
    }

    protected void m_8099_() {
        if (this.m_21824_()) {
            this.registerTamedGoals();
        } else {
            this.registerHostileGoals();
        }
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.registerTamedGoals();
        } else {
            this.registerHostileGoals();
        }
    }

    protected void registerHostileGoals() {
        this.f_21345_.m_148096_();
        this.f_21345_.m_25352_(0, (Goal)new RemainStationaryGoal());
        this.f_21345_.m_25352_(5, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new ApproachTargetGoal((PathfinderMob)this, (Double)RodlingCommonConfig.hostile_follow_target_wanted_distance.get(), (Double)RodlingCommonConfig.hostile_following_movement_speed_multiplier.get(), true));
        this.f_21345_.m_25352_(7, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 10.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]).m_26146_(6000));
        if (((Boolean)RodlingCommonConfig.hostile_attacks_players.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutants_attack_players_off.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(6000));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 20, false, false, entity -> entity.m_6095_().m_204039_(TagInit.EntityTypes.HOSTILE_RODLING_TARGETS)));
    }

    protected void registerTamedGoals() {
        this.f_21345_.m_148096_();
        this.f_21345_.m_25352_(0, (Goal)new RemainStationaryGoal());
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, ((Double)RodlingCommonConfig.tamed_follow_owner_movement_speed_multiplier.get()).doubleValue(), ((Double)RodlingCommonConfig.tamed_follow_owner_start_min_distance.get()).floatValue(), ((Double)RodlingCommonConfig.tamed_follow_owner_stop_max_distance.get()).floatValue(), true));
        this.f_21345_.m_25352_(5, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new ApproachTargetGoal((PathfinderMob)this, (Double)RodlingCommonConfig.tamed_follow_target_wanted_distance.get(), (Double)RodlingCommonConfig.tamed_following_movement_speed_multiplier.get(), true));
        this.f_21345_.m_25352_(7, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new SitWhenWantingToGoal());
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 10.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]).m_26146_(6000));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 20, false, false, entity -> entity.m_6095_().m_204039_(TagInit.EntityTypes.TAMED_RODLING_TARGETS)));
    }

    public void updateConfigurableAttributeValues(boolean setHealth) {
        if (this.m_21824_()) {
            this.setTamedConfigurableAttributeValues(setHealth);
        } else {
            this.setHostileConfigurableAttributeValues(setHealth);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        this.updateConfigurableAttributeValues(true);
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void setHostileConfigurableAttributeValues(boolean setHealth) {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)RodlingCommonConfig.hostile_max_health.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)RodlingCommonConfig.hostile_armour.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)RodlingCommonConfig.hostile_armour_toughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)RodlingCommonConfig.hostile_knockback_resistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)RodlingCommonConfig.hostile_follow_range.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)RodlingCommonConfig.hostile_movement_speed.get()).doubleValue());
        this.m_21051_(Attributes.f_22280_).m_22100_(((Double)RodlingCommonConfig.hostile_movement_speed.get()).doubleValue());
        if (setHealth) {
            this.m_21153_(this.m_21233_());
        }
    }

    public void setTamedConfigurableAttributeValues(boolean setHealth) {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)RodlingCommonConfig.tamed_max_health.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)RodlingCommonConfig.tamed_armour.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)RodlingCommonConfig.tamed_armour_toughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)RodlingCommonConfig.tamed_knockback_resistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)RodlingCommonConfig.tamed_follow_range.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)RodlingCommonConfig.tamed_movement_speed.get()).doubleValue());
        this.m_21051_(Attributes.f_22280_).m_22100_(((Double)RodlingCommonConfig.tamed_movement_speed.get()).doubleValue());
        if (setHealth) {
            this.m_21153_(this.m_21233_());
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return this.canTarget((Entity)target) && super.m_6779_(target);
    }

    boolean canTarget(Entity target) {
        if (!this.m_21824_() && MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.HOSTILE_RODLING_CANT_TARGET, (Entity)this, target, (Entity)this, null)) {
            return true;
        }
        return this.m_21824_() && MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.TAMED_RODLING_CANT_TARGET, (Entity)this, target, (Entity)this, null);
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (super.m_7307_(p_32665_)) {
            return true;
        }
        if (p_32665_ instanceof Rodling && ((Rodling)p_32665_).m_21824_() == this.m_21824_()) {
            return this.m_5647_() == null && p_32665_.m_5647_() == null;
        }
        return false;
    }

    public boolean shouldBeStationary() {
        if (this.isSitting() && !this.wantsToSit()) {
            return false;
        }
        return this.isSitting();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22280_, 0.125).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    protected PathNavigation m_6037_(Level p_218342_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_218342_);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_7023_(Vec3 p_218382_) {
        if (this.m_6142_() || this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_21043_((LivingEntity)this, false);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rodling_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isSitting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rodling_sitting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.noveltyAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rodling_novelty", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rodling_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public void tickDownAnimTimers() {
        if (this.noveltyAnimationTick > 0) {
            --this.noveltyAnimationTick;
        }
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    protected float m_6121_() {
        return this.m_21824_() ? 0.5f : super.m_6121_();
    }

    protected SoundEvent m_7515_() {
        return this.m_21824_() ? (SoundEvent)SoundEventInit.RODLING_IDLE.get() : (SoundEvent)SoundEventInit.RODLING_IDLE_HOSTILE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)SoundEventInit.RODLING_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventInit.RODLING_DEATH.get();
    }

    public int m_8100_() {
        return !this.m_21824_() ? 60 : 120;
    }

    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        if (this.hasShields() && this.getShields() > 0 && p_27567_ != DamageSource.f_19317_ && !this.m_6673_(p_27567_)) {
            Entity entity1 = p_27567_.m_7639_();
            if (entity1 != null) {
                TamableAnimal tamableEntity;
                if (entity1 instanceof LivingEntity && !p_27567_.m_181121_()) {
                    this.m_6703_((LivingEntity)entity1);
                }
                if (entity1 instanceof Player) {
                    this.f_20889_ = 100;
                    this.f_20888_ = (Player)entity1;
                } else if (entity1 instanceof TamableAnimal && (tamableEntity = (TamableAnimal)entity1).m_21824_()) {
                    this.f_20889_ = 100;
                    LivingEntity livingentity = tamableEntity.m_21826_();
                    this.f_20888_ = livingentity != null && livingentity.m_6095_() == EntityType.f_20532_ ? (Player)livingentity : null;
                }
            }
            this.f_19802_ = 20;
            this.breakShield();
            return false;
        }
        if (this.isArmoured() && !p_27567_.m_19376_()) {
            return super.m_6469_(p_27567_, p_27568_ / 2.0f);
        }
        return super.m_6469_(p_27567_, p_27568_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WANTS_TO_SIT, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(ARMOURED, (Object)false);
        this.f_19804_.m_135372_(HAS_SHIELDS, (Object)false);
        this.f_19804_.m_135372_(BURNS_BLOCKS, (Object)true);
        this.f_19804_.m_135372_(ALWAYS_SHOWS_NAME, (Object)false);
        this.f_19804_.m_135372_(SOUL, (Object)false);
        this.f_19804_.m_135372_(SHIELDS, (Object)2);
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        p_21819_.m_128379_("WantsToSit", this.wantsToSit());
        p_21819_.m_128379_("Sitting", this.isSitting());
        p_21819_.m_128379_("Armoured", this.isArmoured());
        p_21819_.m_128379_("HasShields", this.hasShields());
        p_21819_.m_128379_("BurnsBlocks", this.burnsBlocks());
        p_21819_.m_128379_("AlwaysShowsName", this.alwaysShowsName());
        p_21819_.m_128379_("Soul", this.isSoul());
        p_21819_.m_128405_("Shields", this.getShields());
    }

    public void m_7378_(CompoundTag p_21815_) {
        super.m_7378_(p_21815_);
        this.setWantsToSit(p_21815_.m_128471_("WantsToSit"));
        this.setSitting(p_21815_.m_128471_("Sitting"));
        this.setArmoured(p_21815_.m_128471_("Armoured"));
        this.setHasShields(p_21815_.m_128471_("HasShields"));
        this.setBurnsBlocks(p_21815_.m_128471_("BurnsBlocks"));
        this.setAlwaysShowsName(p_21815_.m_128471_("AlwaysShowsName"));
        this.setSoul(p_21815_.m_128471_("Soul"));
        this.setShields(p_21815_.m_128451_("Shields"));
    }

    public boolean wantsToSit() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_SIT);
    }

    public void setWantsToSit(boolean setTo) {
        this.f_19804_.m_135381_(WANTS_TO_SIT, (Object)setTo);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean setTo) {
        this.f_19804_.m_135381_(SITTING, (Object)setTo);
    }

    public boolean isArmoured() {
        return (Boolean)this.f_19804_.m_135370_(ARMOURED);
    }

    public void setArmoured(boolean setTo) {
        this.f_19804_.m_135381_(ARMOURED, (Object)setTo);
    }

    public boolean hasShields() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SHIELDS);
    }

    public void setHasShields(boolean setTo) {
        this.f_19804_.m_135381_(HAS_SHIELDS, (Object)setTo);
    }

    public boolean burnsBlocks() {
        return (Boolean)this.f_19804_.m_135370_(BURNS_BLOCKS);
    }

    public void setBurnsBlocks(boolean setTo) {
        this.f_19804_.m_135381_(BURNS_BLOCKS, (Object)setTo);
    }

    public boolean alwaysShowsName() {
        return (Boolean)this.f_19804_.m_135370_(ALWAYS_SHOWS_NAME);
    }

    public void setAlwaysShowsName(boolean setTo) {
        this.f_19804_.m_135381_(ALWAYS_SHOWS_NAME, (Object)setTo);
    }

    public boolean isSoul() {
        return (Boolean)this.f_19804_.m_135370_(SOUL);
    }

    public void setSoul(boolean setTo) {
        this.f_19804_.m_135381_(SOUL, (Object)setTo);
    }

    public int getShields() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(SHIELDS)), (int)0, (int)2);
    }

    public void setShields(int p_191997_1_) {
        this.f_19804_.m_135381_(SHIELDS, (Object)p_191997_1_);
    }

    public boolean m_6126_() {
        return true;
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (this.hasShields() && this.getShields() < 2 && this.regenerateShieldTick > 0) {
            --this.regenerateShieldTick;
            if (this.regenerateShieldTick == 0) {
                this.regenerateShield();
            }
        }
        if (this.isSitting()) {
            if (this.f_19861_) {
                this.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1, 0.0));
            }
        }
        Vec3 velocity = this.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (!this.f_19853_.f_46443_ && groundSpeed <= 0.1f && this.noveltyAnimationTick <= 0 && this.f_19796_.m_188503_(400) == 0 && (this.m_5448_() == null || this.m_5448_().m_21224_() || this.m_5448_().m_213877_())) {
            this.noveltyAnimationTick = this.noveltyAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
    }

    public void breakShield() {
        this.regenerateShieldTick = this.regenerateShieldTime;
        this.setShields(this.getShields() - 1);
        this.m_5496_((SoundEvent)SoundEventInit.RODLING_SHIELD_BREAK.get(), this.m_6121_(), this.m_6100_());
    }

    public void regenerateShield() {
        this.setShields(this.getShields() + 1);
        this.m_5496_((SoundEvent)SoundEventInit.RODLING_REGENERATE_SHIELD.get(), this.m_6121_(), this.m_6100_());
        this.regenerateShieldTick = this.regenerateShieldTime;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.noveltyAnimationTick = this.noveltyAnimationLength;
        } else if (p_28844_ == 11) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        Item item = itemstack.m_41720_();
        if (itemstack.m_41619_() && this.m_21830_((LivingEntity)p_30412_)) {
            this.setWantsToSit(!this.wantsToSit());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (item == ItemInit.RODLING_CHECKER.get() && !this.m_21824_() && p_30412_.m_7500_() && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_30412_)) {
            this.m_21828_(p_30412_);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setWantsToSit(true);
            this.f_19853_.m_7605_((Entity)this, (byte)7);
            return InteractionResult.SUCCESS;
        }
        if (item == ItemInit.RODLING_CHECKER.get() && this.m_21830_((LivingEntity)p_30412_)) {
            p_30412_.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            if (p_30412_ instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)p_30412_, itemstack);
            }
            if (this.f_19853_.f_46443_) {
                GuiUtils.displayRodlingCheckerGUI(this);
            }
            return InteractionResult.SUCCESS;
        }
        if (item == ItemInit.RODLING_HELMET.get() && (this.m_21830_((LivingEntity)p_30412_) || !this.m_21830_((LivingEntity)p_30412_) && p_30412_.m_7500_())) {
            p_30412_.m_6674_(p_30413_);
            itemstack.m_41774_(1);
            this.setArmoured(true);
            this.m_5496_((SoundEvent)SoundEventInit.RODLING_EQUIP_ARMOUR.get(), this.m_6121_(), this.m_6100_());
            return InteractionResult.SUCCESS;
        }
        if (item == ItemInit.RODLING_SHIELDS.get() && (this.m_21830_((LivingEntity)p_30412_) || !this.m_21830_((LivingEntity)p_30412_) && p_30412_.m_7500_())) {
            p_30412_.m_6674_(p_30413_);
            itemstack.m_41774_(1);
            this.setHasShields(true);
            this.m_5496_((SoundEvent)SoundEventInit.RODLING_EQUIP_SHIELDS.get(), this.m_6121_(), this.m_6100_());
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_204117_(TagInit.Items.HEALS_RODLINGS) && this.m_21830_((LivingEntity)p_30412_) && this.m_21223_() < this.m_21233_()) {
            p_30412_.m_6674_(p_30413_);
            itemstack.m_41774_(1);
            this.m_5634_(this.m_21233_() * (((Integer)RodlingCommonConfig.tamed_fed_heal_percent.get()).floatValue() / 100.0f));
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), 0.0, 0.0, 0.0);
            }
            this.m_5496_((SoundEvent)SoundEventInit.RODLING_HEAL.get(), this.m_6121_(), this.m_6100_());
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_204117_(TagInit.Items.CONVERTS_RODLINGS_TO_SOUL) && (this.m_21830_((LivingEntity)p_30412_) || !this.m_21830_((LivingEntity)p_30412_) && p_30412_.m_7500_()) && !this.isSoul()) {
            p_30412_.m_6674_(p_30413_);
            itemstack.m_41774_(1);
            this.setSoul(true);
            this.m_5496_((SoundEvent)SoundEventInit.RODLING_TRANSFORM_SOUL.get(), this.m_6121_(), this.m_6100_());
            if (this.f_19853_.f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), 0.0, 0.0, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_204117_(TagInit.Items.CONVERTS_RODLINGS_TO_NORMAL) && (this.m_21830_((LivingEntity)p_30412_) || !this.m_21830_((LivingEntity)p_30412_) && p_30412_.m_7500_()) && this.isSoul()) {
            p_30412_.m_6674_(p_30413_);
            itemstack.m_41774_(1);
            this.setSoul(false);
            this.m_5496_((SoundEvent)SoundEventInit.RODLING_TRANSFORM_BLAZE.get(), this.m_6121_(), this.m_6100_());
            if (this.f_19853_.f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), 0.0, 0.0, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_142535_(float p_148989_, float p_148990_, DamageSource p_148991_) {
        return false;
    }

    protected void m_7840_(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    public boolean m_7848_(Animal p_29381_) {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_148993_, AgeableMob p_148994_) {
        return null;
    }

    public boolean m_6898_(ItemStack p_27600_) {
        return false;
    }

    public boolean m_35506_() {
        return false;
    }

    protected void m_21229_() {
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Rodling.this.shouldBeStationary();
        }
    }

    class ShootAttackGoal
    extends Goal {
        public Rodling mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public ShootAttackGoal(Rodling mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            double distance = this.mob.m_21824_() ? (Double)RodlingCommonConfig.tamed_shoot_max_distance.get() : (Double)RodlingCommonConfig.hostile_shoot_max_distance.get();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.mob.f_19797_ >= this.nextUseTime && this.mob.m_142582_((Entity)this.target) && (double)this.mob.m_20270_((Entity)this.target) <= distance && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
            this.mob.m_5496_((SoundEvent)SoundEventInit.RODLING_CHARGE_SHOT.get(), this.mob.m_6121_(), 1.0f);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.mob.shootAnimationTick == this.mob.shootAnimationLength - 5) {
                ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)new EntityTrackingParticleOption("mutantmore:rodling_charge_shot", this.mob.m_19879_(), 0.0, (double)this.mob.m_20206_() * 0.45, 0.0), this.mob.m_20185_(), this.mob.m_20227_(0.45), this.mob.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
                double d1 = this.target.m_20185_() - this.mob.m_20185_();
                double d2 = this.target.m_20227_(0.5) - this.mob.m_20227_(0.5);
                double d3 = this.target.m_20189_() - this.mob.m_20189_();
                if (this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                    RodlingFireball fireball = new RodlingFireball(this.mob.f_19853_, (LivingEntity)this.mob, d1, d2, d3);
                    if (this.mob.m_21824_()) {
                        fireball.damage = ((Double)RodlingCommonConfig.tamed_fireball_damage.get()).floatValue();
                        fireball.fireLength = (Integer)RodlingCommonConfig.tamed_fireball_set_mob_on_fire_length.get();
                        fireball.griefing = this.mob.burnsBlocks();
                        fireball.ignoresInvulTime = (Boolean)RodlingCommonConfig.tamed_ignores_invulnerability_time.get();
                    } else {
                        fireball.damage = ((Double)RodlingCommonConfig.hostile_fireball_damage.get()).floatValue();
                        fireball.fireLength = (Integer)RodlingCommonConfig.hostile_fireball_set_mob_on_fire_length.get();
                        fireball.griefing = (Boolean)RodlingCommonConfig.hostile_fireball_griefing.get() != false && (Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get() == false;
                        fireball.ignoresInvulTime = (Boolean)RodlingCommonConfig.hostile_ignores_invulnerability_time.get();
                    }
                    fireball.m_6034_(fireball.m_20185_(), this.mob.m_20227_(0.5), fireball.m_20189_());
                    this.mob.f_19853_.m_7967_((Entity)fireball);
                    this.mob.m_5496_((SoundEvent)SoundEventInit.RODLING_SHOOT.get(), this.mob.m_6121_(), this.mob.m_6100_());
                }
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + 20;
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class SitWhenWantingToGoal
    extends Goal {
        public SitWhenWantingToGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Rodling.this.wantsToSit() != Rodling.this.isSitting();
        }

        public boolean m_8045_() {
            return Rodling.this.wantsToSit() != Rodling.this.isSitting();
        }

        public void m_8056_() {
            super.m_8056_();
            Rodling.this.setSitting(Rodling.this.wantsToSit());
        }
    }
}

